// $Id: CException.cpp,v 1.6 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CException.hpp"
using Exponent::Exceptions::CException;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CException, CCountedObject);

//	===========================================================================
CException::CException(const CString &errorReason, const CString &functionName, const bool isSerious) 
		  : m_isSerious(true)
		  , m_errorReason(errorReason)
		  , m_functionName(functionName)
{
	EXPONENT_CLASS_CONSTRUCTION(CException);
}

//	===========================================================================
CException::~CException()
{
	EXPONENT_CLASS_DESTRUCTION(CException);
}

//	===========================================================================
const CString &CException::getErrorReason() const 
{ 
	return m_errorReason; 
}

//	===========================================================================
const CString &CException::getFunctionName() const 
{ 
	return m_functionName; 
}

//	===========================================================================
bool CException::errorIsSerious() const
{ 
	return m_isSerious; 
}